<?php

namespace App\Http\Controllers\API;


use Illuminate\Http\Request;
use App\Services\TFAService;

class TFAController extends Controller
{
    /**
     * Method to get QR-code for TFA connection.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getTFAConnectionData()
    {
        return $this->_s( (new TFAService($this->user))->getTFAConnectionData() );
    }

    /**
     * Method to finish connection with TFA app.
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function finishTFAConnection(Request $request)
    {
        $requestData = $this->getRequestData($request);
        $code = $requestData['code'];

        $result = (new TFAService($this->user))->finishTFAConnection($code);

        if (false === $result) {
            return $this->_e('Code ist ungültig');
        }

        return $this->_s();
    }
}