<?php

namespace App\Http\Controllers\API;

use App\Http\Requests\SearchRequest;
use App\Services\SearchService;

class SearchController extends Controller
{
    /**
     * Method to search items by string.
     *
     * @param SearchRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function search(SearchRequest $request)
    {
        $requestData = $this->getRequestData($request);

        $result = (new SearchService($requestData['q']))->findAll();

        return $this->_s($result);
    }
}