<?php

namespace App\Http\Controllers\API;

use App\CouponTemplate;
use App\User;

class ReflinkController extends Controller
{
    /**
     * Method to get seller reflinks.
     *
     * @param User $seller
     * @return \Illuminate\Http\JsonResponse
     */
    public function getSellerLinks(User $seller)
    {
        return $this->_s($seller->links);
    }

    /**
     * Method to get deal reflinks.
     *
     * @param CouponTemplate $deal
     * @return \Illuminate\Http\JsonResponse
     */
    public function getDealLinks(CouponTemplate $deal)
    {
        return $this->_s($deal->links);
    }
}