<?php

namespace App\Http\Controllers\API;


use App\Http\Requests\PayOutRequest;
use App\Services\PayOutService;
use App\Transaction;

class PayOutController extends Controller
{
    /**
     * Method to pay out selected transactions for current user.
     *
     * @param PayOutRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function payout(PayOutRequest $request)
    {
        $requestData = $this->getRequestData($request);

        $transactions = Transaction::whereIn('id', $requestData['items'])
            ->where('user_id', $this->user->id)
            ->where('amount', '>', 0)
            ->where('status', Transaction::STATUS_ALLOCATED)
            ->get();

        (new PayOutService($this->user, $transactions, $requestData['type']))->payOut();

        return $this->_s();
    }
}