<?php

namespace App\Http\Controllers\API;


use Illuminate\Http\Request;

class OptionsController extends Controller
{
    /**
     * Method to get option value by name.
     *
     * @param string $name
     * @return null
     */
    public function get(string $name)
    {
        return $this->_s(option($this->user)->get($name));
    }

    /**
     * Method to set option value by name.
     *
     * @param string $name
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function set(string $name, Request $request)
    {
        $requestData = $this->getRequestData($request);

        $option = option($this->user)->set($name, $requestData['value']);

        return $this->_s($option);
    }
}