<?php

namespace App\Http\Controllers\API;


use App\Services\NewsletterService;
use Illuminate\Support\Facades\Auth;

class NewsletterController extends Controller
{
    /**
     * Method to subscribe user to newsletter.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function subscribe()
    {
        $user = Auth::user();

        (new NewsletterService($user))->subscribe();

        return $this->_s();
    }

    /**
     * Method to unsubscribe user from newsletter.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function unsubscribe()
    {
        $user = Auth::user();

        (new NewsletterService($user))->unsubscribe();

        return $this->_s();
    }
}