<?php

namespace App\Http\Controllers\API;

use App\CouponTemplate;
use App\Http\Requests\UploadRequest;
use App\Http\Resources\MediaResource;
use App\Services\MediaService;

class MediaController extends Controller
{
    /**
     * Method to upload files.
     *
     * @param UploadRequest $request
     * @return mixed
     */
    public function upload(UploadRequest $request)
    {
        if ( $request->file('video') && CouponTemplate::find($request->get('deal_id')) ) {
            $deal = CouponTemplate::find($request->get('deal_id'));
            $video = $request->file('video');
            $added = (new MediaService($deal))->addVideo($video);
            $result = (new MediaResource($added))->toArray();
            return $this->_s($result);
        }

        if ( $request->file('image') && CouponTemplate::find($request->get('deal_id')) ) {
            $deal = CouponTemplate::find($request->get('deal_id'));
            $image = $request->file('image');
            $added = (new MediaService($deal))->addImage($image);
            $result = (new MediaResource($added))->toArray();
            return $this->_s($result);
        }
    }
}