<?php

namespace App\Http\Controllers\API;


use App\Services\VerificationService;
use App\User;

class EmployeeController extends Controller
{
    /**
     * Method to send employee registration link.
     *
     * @param User $employee
     * @return \Illuminate\Http\JsonResponse
     */
    public function sendRegistrationLink(User $employee)
    {
        $seller = $this->user;

        if ( $employee->boss_id !== $seller->id || User::STATUS_PENDING !== $employee->status ) {
            return $this->_e('Forbidden', 403);
        }

        (new VerificationService($employee))->sendEmailEmployeeRegistration();

        activity($employee)->register('registration link resent');

        return $this->_s();
    }
}