<?php

namespace App\Http\Controllers\API;

use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Controller as BaseController;
use App\User;

class Controller extends BaseController
{
    protected $user = null;

    /**
     * Controller constructor.
     */
    public function __construct()
    {
        $this->initUser();
    }

    /**
     * Method to init current user.
     *
     * @param string $token
     */
    private function initUser($token = '')
    {
        if ( Auth::user() ) {
            $this->user = Auth::user();
        }

        if ($token) {
            $this->user = User::where('api_token', $token)->first();
        }
    }

    /**
     * Get request data depends on income format.
     *
     * @param $request
     * @return mixed
     */
    protected function getRequestData($request)
    {
        if ( count($request->json()->all()) ) {
            $requestData = $request->json()->all();
        } else {
            $requestData = $request->all();
        }

        $token = isset($requestData['api_token']) ? $requestData['api_token'] : '';
        $this->initUser($token);

        return $requestData;
    }

    /**
     * Method to return error response.
     *
     * @param $data
     * @param int $code
     * @return \Illuminate\Http\JsonResponse
     */
    protected function _e($data, $code = 422)
    {
        return response()->json(['error' => $data], $code);
    }

    /**
     * Method to return success response
     *
     * @param string $data
     * @param int $code
     * @return \Illuminate\Http\JsonResponse
     */
    protected function _s($data = 'OK', $code = 200)
    {
        return response()->json(['success' => $data], $code);
    }
}