<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Services\CityService;

class CityController extends Controller
{
    /**
     * Method to find cities by search string.
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function find(Request $request)
    {
        $requestData = $this->getRequestData($request);

        $cities = (new CityService())->find($requestData['str']);

        return $this->_s($cities);
    }
}