<?php

namespace App\Http\Controllers\API;


use App\Http\Requests\DetailedActivityRequest;
use App\Services\ActivityService;
use App\User;
use Illuminate\Support\Facades\Auth;

class ActivityController extends Controller
{
    /**
     * Method to get activity by user.
     *
     * @param User $user
     * @return \Illuminate\Http\JsonResponse
     */
    public function getActivity(User $user)
    {
        if ($this->user->id !== $user->boss_id) {
            return $this->_e('Forbidden', 403);
        }

        $log = (new ActivityService($user))->getActivity();

        return $this->_s($log);
    }

    /**
     * Method to get detailed activity.
     *
     * @param DetailedActivityRequest $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function getDetailedActivity(DetailedActivityRequest $request)
    {
        $owner   = Auth::user();
        $users   = $request->get('users', []);
        $actions = $request->get('actions', []);
        $minDate = $request->get('minDate', null);
        $maxDate = $request->get('maxDate', null);

        $log = (new ActivityService($owner))->getDetailedActivity($users, $actions, $minDate, $maxDate);

        return $this->_s($log);
    }
}