<?php

namespace App;

use Illuminate\Support\HtmlString;

trait HasStatus {
    /**
     * Get status of transaciton and attached receipt
     * Can use Single status or status with the class name prefixed
     * Example:
     *
     * "App\Coupon.active"
     * "active"
     *
     * @param string Prefix to use in translations, defaults to classname, falls back to empty prefix
     * @return mixed|string
     */
    public function getStatusText($html = true, $prefix = null)
    {
    	if ($prefix == null) {
		    $prefix = get_class( $this );
	    }
        $key = 'translations.' . $prefix . '.' . $this->status;
        if ($key != trans($key)) {
            $status = trans($key);
        } else {
            $status = trans('translations.' . $this->status); //FIXME: evtl. spezielle translations für receipt
        }
        if ($html) {
            $color = static::STATUS_COLORS[$this->status] ?? 'default';
            $status = new HtmlString('<span class="label label-' . $color . '">' . e($status) . '</span>');
        }
        return $status;
    }

    /**
     * Generate an array with the status values and the translation (for use in selects)
     *
     * @return array
     */
    public static function getStatusOptionArray()
    {
        $result = [];
        foreach(static::STATUS_GROUP_ALL as $status) {
            $result[$status] = trans('translations.' . $status);
        }
        return $result;
    }

}