<?php

namespace App;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;

/**
 * Trait HasMedia
 * @mixin \Illuminate\Database\Eloquent\Model
 */
trait HasMedia
{
    /**
     * Method to store file for media attribute.
     *
     * @param $key
     * @param $value
     */
    public function setAttribute($key, $value)
    {
        if ( in_array($key, $this->mediaAttributes) && $value instanceof UploadedFile ) {
            $ds = DIRECTORY_SEPARATOR;

            //remove old file
            if ( !empty($this->attributes[$key]) && is_file(public_path($this->attributes[$key])) ) {
                File::delete(public_path($this->attributes[$key]));
            }

            // path and name for new file
            $path[] = config('media.base_path', 'media');
            $path[] = strtolower(str_replace('App\\', '', get_class($this)));
            $path[] = strtolower($key);
            $path = implode($ds, $path);
            $name = md5($value->hashName() . time()) . '.' . $value->extension();

            // storing
            $value->move(public_path($path), $name);
            $value = $path . $ds . $name;
        }
        
        $this->attributes[$key] = $value;
    }
}