<?php

namespace App;

trait HasCounters
{
    /**
     * Method to check whether model has counter by its name.
     *
     * @param $counter
     * @return bool
     */
    public function hasCounter($counter)
    {
        return isset($this->counters) && in_array($counter, $this->counters);
    }

    /**
     * Method to check whether model has its own visits counter.
     *
     * @return bool
     */
    public function hasVisitsCounter()
    {
        return $this->hasCounter('visits');
    }

    /**
     * Method to check whether model has its own shares counter.
     *
     * @return bool
     */
    public function hasSharesCounter()
    {
        return $this->hasCounter('shares');
    }
}