<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Presenters\GiftPresenter;
use App\Presenters\PresentsData;

class Gift extends Model
{
    use HasMedia;

    use PresentsData;

    protected $presenter = GiftPresenter::class;

    protected $mediaAttributes = ['image'];

    protected $guarded = [];

    /**
     * Method to return gifts available to attach to deals.
     *
     * @return Gift[]|\Illuminate\Database\Eloquent\Collection
     */
    public static function available()
    {
        // integer 1 or string '1', depends on mysql on server
        return self::where('active', '1')
            ->orWhere('active', 1)
            ->orderBy('price')
            ->get();
    }

    /**
     * Method to check if gift attached to any coupons.
     *
     * @return bool
     */
    public function hasCoupons() : bool
    {
        return (bool)Coupon::where('provision_gift_id', $this->id)
            ->orWhere('discount_gift_id', $this->id)
            ->count();
    }

    /**
     * Method to check if gift attached to any coupon templates.
     *
     * @return bool
     */
    public function hasCouponTemplates() : bool
    {
        return (bool)CouponTemplate::where('provision_gift_id', $this->id)
            ->orWhere('discount_gift_id', $this->id)
            ->count();
    }
}
