<?php

namespace App\Filters;

use App\Services\CityService;
use Illuminate\Database\Eloquent\Builder;

class GeoLocationFilter extends AbstractFilter
{
    private $latitude;
    private $longitude;
    private $city;
    private $distance = 50;

    protected $getParams = [
        'lat',
        'lon',
        'city',
        'plz',
        'loc_id',
    ];

    public $icon = 'fas fa-map-marker-alt';

    /**
     * GeoLocationFilter constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $cityService = new CityService();

        $this->latitude  = (float)request('lat');
        $this->longitude = (float)request('lon');
        $this->city      = $cityService->getCity();

        $this->initTitle();

        $cityService->saveSearchToSession();
    }

    private function initTitle()
    {
        $this->title = "In der Nähe von {$this->city->zip} {$this->city->name}";
    }

    /**
     * Method to apply filter.
     *
     * @param Builder $builder
     * @return Builder
     */
    public function apply(Builder $builder)
    {
        $builder->selectRaw('
            ( 
                6371 * acos( cos( radians(' . $this->latitude . ') ) * cos( radians( lat ) ) * cos( radians( lon ) - radians(' . $this->longitude . ') ) + sin( radians(' . $this->latitude . ') ) * sin(radians(lat)) ) 
            ) AS distance
        ');
        $builder->having('distance', '<=', $this->distance);

        return $builder;
    }

    /**
     * Method to return current filtered city.
     *
     * @return mixed
     */
    public function getCity()
    {
        return $this->city;
    }
}