<?php

namespace App\Filters;

use App\Library\Utils;

class AbstractFilter
{
    protected $getParams;

    /**
     * Fontawesome 4 icon class.
     *
     * @var string
     */
    public $icon = 'fas fa-filter';

    /**
     * Filter title.
     *
     * @var string
     */
    public $title;

    /**
     * Link to remove current filter.
     *
     * @var string
     */
    public $removeLink;

    /**
     * AbstractFilter constructor.
     */
    public function __construct()
    {
        $this->initRemoveLink();
    }

    /**
     * Method to initialize remove link.
     */
    private function initRemoveLink()
    {
        $this->removeLink = Utils::removeParamsFromURI(request()->fullUrl(), $this->getParams);
    }
}