<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class FAQ extends Model
{
    protected static $groups = [
        'Allgemeine Fragen',
        'Fragen zur Mitgliedschaft',
        'Fragen zur Zahlung',
        'Fragen zur RECO.MA Nutzung',
        'Fragen zum Profil',
        'Fragen zur Sicherheit',
        'Sonstige Fragen',
    ];

    protected static $faq = [
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Für wen ist RECO.MA geeignet?',
            'answer' => 'Unser Angebot richtet sich an Unternehmen, die Ihre Dienstleistungen und Produkte durch zufriedene Kunden weiterempfehlen lassen wollen. Ebenso an Privatpersonen, die ihrem Netzwerk gute Unternehmen, Dienstleistungen und Produkte empfehlen möchten sowie Privatpersonen, die bei ihren Einkäufen und Aufträgen auf die wertvollen Erfahrungen ihres Netzwerkes zurückgreifen und dabei Geld sparen möchten.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Warum sollte ich RECO.MA nutzen?',
            'answer' =>
                <<<HTML
                    Mit RECO.MA kannst Du Deinen Freunden und Bekannten Dienstleister und Händler, mit denen Du selbst oder die Community gute Erfahrungen gesammelt haben, empfehlen. Du schickst Deinen Freunden einfach einen RECO.BON per E-Mail oder SMS zu. Folgt Dein Freund dieser Empfehlung, erhält er Cashback und spart bares Geld. Das Beste daran: Dein Freund spart Geld und Du wirst nach erfolgreichem Abschluss mit einer Geldprämie belohnt.

Wo es das gibt? Nur bei RECO.MA, denn ein guter Rat ist Geld wert - ist nun mal unsere Meinung.
HTML
            ,
            'roles' => 'agent',
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Kann ich mit RECO.MA reich werden?',
            'answer' => 'Dein Erfolg hängt von Deinem persönlichen Einsatz und Deiner Community bzw. Deinem Netzwerk ab. Wenn Du ein großes Netzwerk hast und RECO.MA sehr aktiv nutzt, kannst Du ein erhebliches passives Einkommen generieren.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was ist ein RECO.BON? ',
            'answer' => 'Der RECO.BON ist ein Gutschein, der einem Endverbraucher einen Anspruch auf ein prozentuales Cashback auf einen Einkauf oder Auftrag und einem Empfehler einen Anspruch auf ein prozentuales RECO.CASH verschafft.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was bedeutet RECO.CASH?',
            'answer' => 'RECO.CASH ist eine erfolgsabhängige Vergütung für eine erfolgreiche Empfehlung und ist unter andrem auch als Provision bekannt.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was genau ist Cashback?',
            'answer' =>
                <<<HTML
                    Cashback kommt aus dem Englischen und bedeutet &laquo;Geld zurück&raquo;. Dahinter steckt ein besonderes System, das dem Käufer dabei hilft Geld bei Aufträgen und Einkäufen zu sparen. Auf den Punkt gebracht bedeutet es, dass der Käufer einen Teil seines Einkaufswertes nach dem Einkauf zurück erhält.

Ein kleines Beispiel:

Franz kauft ein Produkt für 1190 Euro. Der Nettobetrag ist 1000 und die Cashback Rate liegt bei 10 %. Somit erhält Franz 100 Euro Cashback. Das Cashback bekommt Franz ganz praktisch nach der kompletten Auftragsabwicklung gutgeschrieben, anschließend kann sich Franz das Geld auf sein Bankkonto überweisen lassen. 
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wie funktioniert das? Wie erhalte ich mein RECO.CASH?',
            'answer' =>
                <<<HTML
                    Du empfiehlst Deinem Freund einen Dienstleister oder Händler indem Du ihm einen RECO.BON per E-Mail oder SMS schickst. Wenn Dein Freund seinen personifizierten RECO.BON (Gutschein) beim Dienstleister einlöst, wissen wir und der Dienstleister von wem die Empfehlung kam.

Dein RECO.CASH wird sofort in unserem System erfasst. Sobald der Kauf oder Auftrag abgewickelt ist und Dein Freund den Rechnungsbetrag beglichen hat, kannst Du Dir Deine Provision ab dem ersten Cent auf Dein Girokonto auszahlen lassen. 
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wie hoch ist das RECO.CASH?',
            'answer' => 'Das ist von RECO.BON zu RECO.BON unterschiedlich und hängt von unserem Partner ab. Er legt Dein RECO.CASH selbst als prozentualen Wert fest. Diesen Wert kannst Du in Deinem Dashboard im Menüpunkt &laquo;RECO.BON EMPFEHLEN&raquo; einsehen. Das RECO.CASH wird vom Netto Rechnungsbetrag berechnet.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wieso könnt ihr mir so hohe Provisionen auszahlen?',
            'answer' => 'Dienstleister und Händler legen Dein RECO.CASH (Provision) selbst fest. Dieses RECO.CASH geben wir zu 100 % an Dich weiter. Denn Du sollst für Deine Mühe belohnt werden.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wann habe ich Anspruch auf das RECO.CASH?',
            'answer' => 'Dein Anspruch entsteht nicht für den Empfehlungsabschluss, sondern erst, nachdem der Auftrag oder Kauf ausgeführt und der Rechnungsbetrag vollständig beglichen wurde. Sollte der Auftrag oder Kauf nachträglich im Rahmen der gesetzlichen Regelungen sowie der allgemeinen Geschäftsbedingungen des jeweiligen Unternehmens storniert werden, erlischt Dein Anspruch auf das RECO.CASH.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'In welchen Fällen kann kein RECO.CASH ausgezahlt werden?',
            'answer' =>
                <<<HTML
                    <ul>
    <li>Wenn der Einkauf oder Auftrag nachträglich storniert wurde oder eine Rückgabe stattgefunden hat.</li>
    <li>Wenn zusätzliche Gutscheine verwendet wurden, die nicht bei RECO.MA gelistet sind.</li>
    <li>Wenn Du Dich mit falschen Daten registriert hast.</li>
    <li>Wenn gegen unsere AGB und Richtlinien verstoßen wurde.</li>
</ul>
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Ist RECO.MA kostenlos?',
            'answer' => 'Für Dich als Empfehler ist RECO.MA kostenlos. Dir entstehen also keinerlei Kosten für die Nutzung unseres Portals.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Wie kann ich mich registrieren?',
            'answer' =>
                <<<HTML
                    Die Mitgliedschaft ist exklusiv und nur einem eingeladenen Personenkreis vorbehalten.

Du erhältst von einem Unternehmen einen Einladungslink per E-Mail oder SMS. Nach einem Klick auf diesen Link kannst Du Dein persönliches Passwort wählen. Vervollständige nur noch Dein Profil, um ab jetzt mit RECO.MA passives Einkommen zu verdienen. 
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Kann sich jeder ohne weiteres als Empfehler bei RECO.MA registrieren?',
            'answer' => 'Nein. Ein Unternehmen, das bei RECO.MA gelistet ist, muss Dich als Empfehler einladen. Ohne diese Einladung kannst Du Dich leider nicht bei RECO.MA registrieren. Die Mitgliedschaft für Dich ist übrigens vollkommen kostenlos.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Kann ich weitere Empfehler einladen?',
            'answer' => 'Nein, das geht leider nicht. Empfehler können nur von Unternehmen, die bei RECO.MA gelistet sind, eingeladen werden.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Gibt es eine Höhe, ab der ich meine Provisionen auszahlen lassen kann?',
            'answer' => 'Nein. Die Provision kann ab dem ersten bestätigten Cent ausgezahlt werden.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Wie lange dauert es, bis ich mein RECO.CASH erhalte?',
            'answer' => 'Das ist individuell und hängt vom Händler oder Dienstleister sowie von dem Produkt oder dem Auftrag ab, das bzw. den Du vermittelt hast. In der Regel erhältst Du Dein RECO.CASH 10 Werktage nachdem der Auftrag oder das Produkt vollständig bezahlt wurde bzw. der Dienstleister oder Händler die Transaktionen bestätigt und abgeschlossen hat.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Wie kann ich das RECO.CASH auf mein Bankkonto auszahlen lassen?',
            'answer' => 'Dein RECO.CASH kannst Du über das RECO.MA Portal auszahlen lassen, indem Du auf den Button &laquo;AUSZAHLEN&raquo; in der RECO.CASHBAR klickst. Anschließend wird das Guthaben noch am selben Tag auf Dein Girokonto überwiesen.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Kann ich mein RECO.CASH auf unterschiedliche Bankkonten überweisen lassen?',
            'answer' => 'Nein. Dein RECO.CASH wird auf die in Deinem Profil hinterlegte Bankverbindung überwiesen.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Was bedeutet AUSGEZAHLT, OFFEN und KONTOSTAND in meiner RECO.CASHBAR?',
            'answer' =>
                <<<HTML
                    In Deiner RECO.CASHBAR werden die aktuellen Geldwerte Deines Profils dargestellt.
<ul>
    <li>AUSGEZAHLT zeigt Dir, wie viel RECO.CASH DU Dir bereits auf Dein Girokonto ausgezahlt hast.</li>
    <li>OFFEN zeigt Dir das Cashback aus den aktuell vermittelten aber noch nicht abgeschlossenen RECO.BONS. Sobald Dein Freund die Rechnung beglichen hat und das Unternehmen die Zahlung erhalten hat, wandert der Betrag aus der jeweiligen Empfehlung in den KONTOSTAND.</li>
</ul>
Im KONTOSTAND wird der RECO.CASH Betrag angezeigt, der Dir ausgezahlt werden kann.
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Kann ich den Bewertungen vertrauen?',
            'answer' => 'Jeder Verbraucher muss nach Ausführung eines Auftrages das Unternehmen fair bewerten. So können sich weitere Empfehler und Verbraucher objektiv an vorherigen Erfahrungen orientieren und sich für oder gegen ein Unternehmen entscheiden.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Kann ich Bewertungen abgeben?',
            'answer' => 'Das geht leider nicht. Du kannst aus Deiner Rolle als Empfehler keine Bewertungen abgeben.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Was ist der Unterschied zwischen &laquo;Unternehmen empfehlen&raquo; und &laquo;RECO.BON empfehlen&raquo;?',
            'answer' =>
                <<<HTML
    Im Bereich &laquo;Unternehmen empfehlen&raquo; empfiehlst Du Deinem Freund das Unternehmen selbst. Sollte das Unternehmen mehrere RECO.BONS haben, kann sich Dein Freund den für sich relevanten RECO.BON aussuchen und verwenden.

Im Bereich RECO.BON empfehlen kannst Du direkt einen RECO.BON eines Unternehmens an Deinen Freund weiterempfehlen. 
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Kann ich RECO.BONS an mich selbst empfehlen?',
            'answer' => 'Das geht leider nicht. Du kannst jedoch Unternehmen und RECO.BONS an Deine Freunde und Familie empfehlen, sodass auch sie von Deinem Netzwerk und RECO.MA profitieren können.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Wie kann ich ein Unternehmen empfehlen?',
            'answer' =>
                <<<HTML
                    Du kannst ein Unternehmen aus Deinem Dashboard empfehlen, indem Du folgende Schritte befolgst:
<ul>
    <li>Klicke im Dashboard das Schaltfeld &laquo;UNTERNEHMEN EMPFEHLEN&raquo;. Alternativ gelangst Du über den Menüpunkt &laquo;Unternehmen empfehlen&raquo; in die Übersicht der Unternehmen, mit denen Du bereits zusammenarbeitest und mit denen Du noch nicht zusammenarbeitest.</li> 
    <li>Suche nun das Unternehmen aus, welches Du empfehlen möchtest. Du kannst hierfür auch die Suche verwenden und die Auswahl eingrenzen lassen.</li>
    <li>Klicke auf die Schaltfläche &laquo;EMPFEHLEN&raquo;</li> 
    <li>Trage nun der Reihe nach folgende Daten Deines Freundes ein:</li>
    <ul>
        <li>die Anrede,</li>
        <li>den Vornamen,</li> 
        <li>den Nachnamen,</li> 
        <li>die Handynummer, dadurch erhält Dein Freund Deine Empfehlung sofort per SMS</li>
        <li>die E-Mail-Adresse</li>
    </ul>
    <li>Klicke jetzt auf &laquo;SENDEN&raquo;</li> 
</ul>
Die Empfehlung wird sofort an Deinen Freund versendet. Sollte das Unternehmen mehrere RECO.BONS anbieten, kann sich Dein Freund seinen RECO.BON aussuchen. 
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie kann ich ein RECO.BON empfehlen?',
            'answer' =>
                <<<HTML
                    Du kannst nur RECO.BONS von den Unternehmen empfehlen, mit denen Du bereits zusammenarbeitest. Du empfiehlst einen RECO.BON aus Deinem Dashboard, indem Du folgende Schritte befolgst:
<ul>
    <li>Klicke im Dashboard das Schaltfeld &laquo;RECO.BON EMPFEHLEN&raquo;. Alternativ gelangst Du über den Menüpunkt &laquo;RECO.BON empfehlen&raquo; in die Übersicht der RECO.BONS, die Du empfehlen kannst.</li>  
    <li>Suche nun den RECO.BON aus, den Du empfehlen möchtest. Du kannst hierfür auch die Suche verwenden und die Auswahl eingrenzen lassen.</li> 
    <li>Klicke auf die Schaltfläche &laquo;EMPFEHLEN&raquo;</li> 
    <li>Trage nun der Reihe nach folgende Daten Deines Freundes ein:</li> 
    <ul>
        <li>die Anrede,</li>
        <li>den Vornamen,</li> 
        <li>den Nachnamen,</li> 
        <li>die Handynummer, dadurch erhält Dein Freund Deine Empfehlung sofort per SMS</li>
        <li>die E-Mail-Adresse</li>
    </ul>
    <li>Klicken jetzt auf &laquo;SENDEN&raquo;</li> 
</ul>
Die Empfehlung wird sofort an Deinen Freund versendet.
HTML
            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Wieso und wie soll ich meine Handynummer verifizieren?',
            'answer' =>
                <<<HTML
    Damit können wir sicherstellen, dass Dein Profil nicht missbraucht wird. Zudem haben wir die Möglichkeit, Deine Empfehlungen direkt per SMS an Deinen Freund zu versenden. Das hat einen enormen Vorteil: Dein Freund erhält die Empfehlung sofort per SMS auf sein Handy und kann den RECO.BON innerhalb weniger Minuten vor Ort einsetzen.

Bitte befolge die folgenden Schritte, um Deine Handynummer zu verifizieren:
<ul>
    <li>Klicke auf &laquo;Profil&raquo; in der linken Menüleiste</li> 
    <li>Klicke im Bereich &laquo;Handynummer&raquo; auf die Schaltfläche &laquo;AKTIVIEREN&raquo; – wir senden Dir umgehend einen Verifizierungscode per SMS zu.</li>
    <li>Trage Deinen Code in das Feld &laquo;Verifizierungscode&raquo; ein</li> 
    <li>Klicke auf &laquo;Absenden&raquo;</li> 
</ul>
Deine Handynummer ist nun verifiziert.

Wenn Du eine Empfehlung abgeben möchtest und Deine Handynummer noch nicht verifiziert ist, klicke bitte auf das Schaltfeld &laquo;ZUR VERIFIZIERUNG&raquo;. Du gelangst direkt zur Verifizierung und musst
<ul>
    <li>die Schaltfläche &laquo;AKTIVIEREN&raquo; klicken – wir senden Dir umgehend einen Verifizierungscode per SMS zu.</li>
    <li>Trage Deinen Code in das Feld &laquo;Verifizierungscode&raquo; ein</li> 
    <li>Klicke auf &laquo;Absenden&raquo;</li> 
</ul>
Deine Handynummer ist nun verifiziert. 
HTML

            ,
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Wie kann ich Kontakt zu einem Unternehmen aufnehmen?',
            'answer' => 'Du kannst mit jedem Unternehmen telefonisch und schriftlich in Kontakt treten. Auf der Profilseite des Unternehmens sind die Kontaktdaten wie bspw. die Rufnummer und die E-Mail-Adresse hinterlegt.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung ',
            'question' => 'Was passiert, wenn mein Freund von seinem Kauf oder Auftrag zurücktritt?',
            'answer' => 'Sollte Dein Freund vom Kauf oder Auftrag im Rahmen der gesetzlichen Regelungen sowie der allgemeinen Geschäftsbedingungen des jeweiligen Unternehmens zurücktreten, kann Dir für Deine Empfehlung leider kein RECO.CASH ausgezahlt werden.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zum Profil',
            'question' => 'Muss ich meine Profildaten direkt nach meiner Registrierung vervollständigen?',
            'answer' => 'Ja, nur so kannst Du von RECO.MA profitieren. Solange Dein Profil nicht vollständig ausgefüllt ist, können wir Dir kein RECO.CASH auszahlen.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zum Profil',
            'question' => 'Wie ändere ich meine Profildaten?',
            'answer' => 'Du kannst Deine Stamm- bzw. Profildaten in Deinem geschützten Bereich unter dem Menüpunkt &laquo;Profil&raquo; ändern. Nach der Aktualisierung musst Du die Änderung mit &laquo;Speichern&raquo; bestätigen.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zum Profil',
            'question' => 'Wie ändere ich mein Passwort?',
            'answer' => 'Du kannst in Deinem geschützten Bereich das Passwort unter dem Menüpunkt &laquo;Profil&raquo; im Reiter &laquo;Passwort&raquo; ändern. Nach der Aktualisierung musst Du die Änderung mit &laquo;Speichern&raquo; bestätigen.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Fragen zur Sicherheit',
            'question' => 'Wie sicher ist RECO.MA?',
            'answer' => <<<HTML
Wir unternehmen immense Anstrengungen für die Datensicherheit und setzen neben den modernsten Servern auf spezielle Sicherheitstechniken, um eventuellen Datendiebstahl und Datenverlust zu verhindern. Unsere Soft- und Hardware wird auf dem neuesten Stand der Technik gehalten und ständig aktualisiert.

Wir halten uns strikt an die gesetzlichen Datenschutzgesetze. Zusätzlich gewähren wir den Schutz Deiner Daten durch folgende Sicherheitsmaßnahmen:
<ul>
    <li>256bit SSL-Verschlüsselung</li> 
    <li>Verschlüsselte Datenbankinhalte</li> 
    <li>Serverstandort Deutschland</li> 
    <li>Verwendung mehrere Server</li> 
    <li>Frühwarnsysteme</li>
    <li>Regelmäßige Softwareupdates</li> 
    <li>Keine Weitergabe von Daten</li> 
    <li>Lokales Team</li> 
</ul>
Detaillierte Informationen findest Du in unseren Datenschutzrichtlinien
HTML
            ,
            'roles' => 'agent,consumer,seller'
        ],
        [
            'group' => 'Fragen zur Sicherheit',
            'question' => 'Wer hat außer mir noch Zugriff auf meine Erfolgskennzahlen?',
            'answer' => 'Du hast den alleinigen Zugriff auf Dein RECO.MA Dashboard. Bitte gib Deine Anmeldedaten nie an Dritte weiter. Deine Datensicherheit ist uns sehr wichtig.',
            'roles' => 'agent'
        ],
        [
            'group' => 'Sonstige Fragen',
            'question' => 'Gibt es eine mobile App?',
            'answer' => 'Nein, Du kannst das RECO.MA Portal vollumfänglich auf Deinem Smartphone oder Tablett nutzen. Wir haben das Design auf die mobile Nutzung ausgelegt. Es werden sämtliche gängige Smartphone Modelle unterstützt.',
            'roles' => 'agent,consumer,seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Warum sollte ich RECO.MA nutzen?',
            'answer' =>
                <<<HTML
                    Mit RECO.MA erhältst Du Empfehlungen von Deinen Freunden. Wenn Dein Freund Dir ein Unternehmen oder ein Produkt über RECO.MA empfiehlt und Du seiner Empfehlung folgst, erhältst Du Cashback und sparst so bares Geld.

Wo es das gibt? Nur bei RECO.MA! wir finden Du solltest nur mit Unternehmen arbeiten, mit denen andere gute Erfahrungen gemacht haben und dabei auch finanziell profitieren. Das ist nun mal unsere Meinung. 
HTML
            ,
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was ist ein RECO.BON?',
            'answer' => 'Der RECO.BON ist ein Gutschein, der Dir als Endverbraucher einen Anspruch auf ein prozentuales Cashback bei einem unserer Partner verschafft.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Gibt es bei Euch Cashback oder Rabatt?',
            'answer' => 'Du erhältst Rabatt in Form eines Cashbacks.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was genau ist Cashback?',
            'answer' =>
                <<<HTML
                    Cashback kommt aus dem Englischen und bedeutet &laquo;Geld zurück&raquo;, dahinter steckt ein besonderes System, dass Dir dabei hilft, Geld bei Aufträgen und Einkäufen zu sparen. Auf den Punkt gebracht bedeutet es, dass Du einen Teil deines Einkaufswertes nach dem Einkauf zurück erhältst.

Ein kleines Beispiel:

Du kaufst ein Produkt für 1190 Euro. Der Nettobetrag ist 1000 und die Cashback Rate liegt bei 10 %. Somit erhältst Du 100 Euro Cashback. Das Cashback bekommst Du ganz praktisch nach der kompletten Auftragsabwicklung gutgeschrieben, anschließend kannst Du es Dir auf Dein Bankkonto überweisen lassen. 
HTML
            ,
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wie funktioniert das? Wie erhalte ich Cashback?',
            'answer' =>
                <<<HTML
                    Du erhältst eine Empfehlung von Deinem Freund. In Deinem geschützten Bereich entscheidest Du Dich für einen RECO.BON, der auf Dich personifiziert ist. Diesen RECO.BON legst Du dem Dienstleister oder Händler während deines Einkaufs oder der Auftragsvergabe vor Ort vor.

Dein Rabatt wird als Cashback sofort in unserem System erfasst. Sobald der Kauf oder Auftrag zwischen Dir und Deinem Dienstleister abgewickelt ist und Du den Rechnungsbetrag bezahlt hast, kannst Du Dir Dein Cashback ab dem ersten Cent auf Dein Girokonto auszahlen lassen. 
HTML
            ,
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wie viel Cashback erhalte ich?',
            'answer' => 'Das Cashback ist individuell und wird von jedem Dienstleister für die jeweiligen Produkte und Dienstleistungen festgelegt.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Habe ich Anspruch auf das RECO.CASH?',
            'answer' => 'Dein Anspruch entsteht nicht für den Kauf- bzw. Auftragsabschluss, sondern erst, nachdem der Auftrag oder Kauf ausgeführt und der Rechnungsbetrag von Dir vollständig beim Unternehmen beglichen wurde, kurzum wenn Du die Rechnung voll bezahlt hast. Sollte der Auftrag oder Kauf nachträglich im Rahmen der gesetzlichen Regelungen sowie der allgemeinen Geschäftsbedingungen des jeweiligen Unternehmens storniert werden, erlischt Dein Anspruch auf das Cashback.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wieso könnt ihr mir so hohe Prämien auszahlen?',
            'answer' => 'Dienstleister und Händler legen Deine Prämie selbst fest. Diese Prämie geben wir als Cashback zu 100 % an Dich weiter.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wie hoch ist mein Cashback?',
            'answer' => 'Das ist von RECO.BON zu RECO.BON unterschiedlich und hängt von unserem Partner ab. Er selbst legt Dein Cashback als prozentualen Wert fest. Diesen Wert kannst Du auf Deinem RECO.BON im rechten unteren Bereich sehen. Das Cashback wird vom Netto Rechnungsbetrag berechnet.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Ist RECO.MA kostenlos?',
            'answer' => 'Für Dich als Verbraucher ist und bleibt RECO.MA kostenlos. Dir entstehen also keinerlei Kosten für die Nutzung unseres Portals.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'In welchen Fällen können keine Prämien ausgezahlt werden?',
            'answer' =>
                <<<HTML
    <ul>
    <li>Wenn Du Deinen Einkauf oder Auftrag nachträglich stornierst oder eine Rückgabe stattgefunden hat.</li>
    <li>Wenn zusätzliche Gutscheine verwendet wurden, die nicht bei RECO.MA gelistet sind.</li>
    <li>Wenn Du Dich mit falschen Daten angemeldet hast.</li>
    <li>Wenn gegen unsere AGB verstoßen wurde.</li> 
</ul>
HTML
            ,
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Muss ich meinen RECO.BON einlösen?',
            'answer' => 'Du kannst Deinen RECO.BON einlösen, wenn Du Dich für einen Auftrag oder einen Kauf bei einem Unternehmen entschieden hast. Hast Du Dich gegen einen Kauf entschieden, entstehen Dir keine Verpflichtungen.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Wie kann ich mich registrieren?',
            'answer' => 'Du erhältst von einem Freund eine Empfehlung per E-Mail oder SMS. Die Empfehlung enthält einen RECO.BON (Gutschein) sowie einen Anmeldelink. Nach einem Klick auf diesen Link kannst Du Dein persönliches Passwort wählen. Vervollständige nur noch Dein Profil, um ab jetzt mit RECO.MA von guten Erfahrungen deines Freundes profitieren zu können und zudem bares Geld in Form von Cashback zu sparen.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Kann ich mich ohne weiteres als Verbraucher bei RECO.MA registrieren?',
            'answer' => 'Nein. Ein Freund oder Bekannter muss Dir über RECO.MA eine Empfehlung zusenden. Ohne diese Empfehlung kannst Du Dich leider nicht bei RECO.MA registrieren. Die Mitgliedschaft für Dich ist übrigens vollkommen kostenlos.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Wie lange dauert es, bis ich mein Cashback erhalte?',
            'answer' => 'Das ist individuell und hängt vom Händler oder Dienstleister sowie von dem Produkt ab, das Du erworben oder für das Du einen Auftrag erstellt hast. In der Regel erhältst Du Dein Cashback 10 Werktage nachdem der Auftrag oder das Produkt vollständig bezahlt wurde bzw. der Dienstleister oder Händler die Transaktionen bestätigt und abgeschlossen hat.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Wie kann ich mein Cashback auf mein Bankkonto auszahlen lassen?',
            'answer' => 'Du musst Dich zuerst mit Deinen Anmeldedaten bei RECO.MA anmelden. In Deinem Dashboard siehst Du in der Kontoleiste Deinen &laquo;Kontostand&raquo;. Ist Dein Cashback vorgemerkt, findest Du den Betrag in &laquo;OFFEN&raquo; – sobald der Dienstleister die Transaktion abgeschlossen und die Zahlung bestätigt hat, wird im Bereich &laquo;Kontostand&raquo; Dein verfügbares Cashback angezeigt. Mit einem Klick auf &laquo;Auszahlen&raquo; kannst Du Dir Dein offenes Cashback auszahlen lassen.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Gibt es eine Höhe, ab der ich mein Cashback auszahlen lassen kann?',
            'answer' => 'Nein. Dein Cashback kann ab dem ersten bestätigten Cent ausgezahlt werden.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Kann ich mein Cashback auf unterschiedliche Bankkonten überweisen lassen?',
            'answer' => 'Nein. Das Cashback wird auf die in Deinem Profil hinterlegte Bankverbindung überwiesen.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Kann ich den Bewertungen vertrauen?',
            'answer' => 'Jeder Verbraucher muss das Unternehmen nach Ausführung eines Auftrages fair bewerten. So können sich weitere Empfehler und Verbraucher objektiv an vorherigen Erfahrungen orientieren und sich für oder gegen ein Unternehmen entscheiden.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wo finde ich meinen RECO.BON?',
            'answer' => 'Logge Dich mit Deinen Zugangsdaten ein, um Deinen RECO.BON anzusehen oder auszudrucken. Im Menüpunkt RECO.BON sind alle Dir empfohlenen RECO.BONS dargestellt. Mit einem Klick auf den Button &laquo;DRUCKEN&raquo; kannst Du den RECO.BON auf Deinem Drucker ausdrucken oder aber auch als PDF speichern.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie verwende ich meinen RECO.BON?',
            'answer' => 'Nachdem Du einen RECO.BON erhalten hast, kannst Du Deinen RECO.BON ganz einfach einlösen. Dazu legst Du während deines Auftrages oder Einkaufs einen Ausdruck des RECO.BONS bei dem jeweiligen Dienstleister oder Händler vor, alternativ kannst Du Ihm den RECO.BON auf Deinem Smartphone oder Handy vorzeigen. Wichtig ist, dass die Gültigkeit des RECO.BONS noch nicht abgelaufen ist.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Mir wurde ein Unternehmen empfohlen, kann ich alle seine RECO.BONS einlösen?',
            'answer' => 'Wähle den RECO.BON aus, der Dir für Deinen Kauf oder Auftrag am besten und ehesten zusagt. Anschließend kannst Du diesen RECO.BON einlösen.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Warum wird auf meinem RECO.BON ein Prozentbetrag angezeigt? ',
            'answer' => 'Um eine unkomplizierte Abwicklung zu gewährleisten, wird auf jedem RECO.BON der prozentuale Cashback angegeben. Wir möchten damit sicherstellen, dass Du und das Unternehmen einen direkten Überblick über den Cashbackwert habt.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Ich habe eine Frage zum RECO.BON oder Unternehmen.',
            'answer' => 'Du kannst die Informationen über Deinen erhaltenen RECO.BON direkt auf dem RECO.BON einsehen. Wenn Du Fragen zum Unternehmen bzw. Partner hast, ist der schnellste und einfachste Weg sich direkt beim Partner zu erkundigen. Die Kontaktinformationen des Partners findest Du direkt auf dem RECO.BON oder durch einen Klick auf den Firmennamen des Partners.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Kann ich die Gültigkeit des RECO.BONS verlängern?',
            'answer' => 'Das geht leider nicht. Bitte achte darauf, dass Du Deinen RECO.BON im Gültigkeitszeitraum einlöst.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Kann ich von einem bereits getätigten Kauf oder vergebenen Auftrag zurücktreten?',
            'answer' =>
                <<<HTML
    Das kommt auf den individuellen Fall an. Grundsätzlich läuft Dein Rücktritt außerhalb von RECO.MA ab und es gelten in solchen Fällen die gesetzlichen Regelungen sowie die allgemeinen Geschäftsbedingungen des jeweiligen Unternehmens.

Solltest Du von Deinem Kauf oder Auftrag zurücktreten, kann Dir leider kein Cashback ausgezahlt werden.
HTML
            ,
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie kann ich eine Bewertung abgeben?',
            'answer' => 'Bevor Du Dir Dein Cashback auszahlen lassen kannst, musst Du eine Bewertung abgeben. Damit wollen wir erreichen, dass alle Kunden eine faire Bewertung abgeben und weitere Empfehler und Verbraucher objektiv von vorherigen und insbesondere Deinen Erfahrungen profitieren können.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Kann ich selbst RECO.BONS empfehlen?',
            'answer' => 'Du kannst aus Deiner Rolle als Verbraucher keine RECO.BONS empfehlen. Sprich doch einfach das Unternehmen an, bei dem Du Deinen RECO.BON vorgelegt hast, er wird Dich gerne als Empfehler einladen. Anschließend kannst Du RECO.BONS empfehlen und so ein passives Einkommen generieren.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zum Profil',
            'question' => 'Wie ändere ich meine Profildaten?',
            'answer' => 'Du kannst Deine Stamm- bzw. Profildaten in Deinem geschützten Bereich unter dem Menüpunkt &laquo;Profil&raquo; ändern. Nach der Aktualisierung musst Du die Änderung mit &laquo;Speichern&raquo; bestätigen.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zum Profil',
            'question' => 'Wie ändere ich mein Passwort?',
            'answer' => 'Du kannst in Deinem geschützten Bereich das Passwort unter dem Menüpunkt &laquo;Profil&raquo; im Reiter &laquo;Passwort&raquo; ändern. Nach der Aktualisierung musst Du die Änderung mit &laquo;Speichern&raquo; bestätigen.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Fragen zur Sicherheit',
            'question' => 'Wer hat außer mir noch Zugriff auf meine RECO.BONS?',
            'answer' => 'Du hast den alleinigen Zugriff auf Dein RECO.MA Dashboard. Bitte gib Deine Anmeldedaten nie an Dritte weiter. Deine Datensicherheit ist uns sehr wichtig.',
            'roles' => 'consumer'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Für wen ist RECO.MA geeignet?',
            'answer' => 'Unser Angebot richtet sich an Unternehmen, die Ihre Dienstleistungen und Produkte durch zufriedene Kunden weiterempfehlen lassen wollen. Ebenso an Privatpersonen, die ihrem Netzwerk gute Unternehmen, Dienstleistungen und Produkte empfehlen möchten sowie Privatpersonen, die bei ihren Einkäufen und Aufträgen auf die wertvollen Erfahrungen ihres Netzwerkes zurückgreifen und dabei Geld sparen möchten.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was ist ein RECO.BON?',
            'answer' => 'Der RECO.BON ist ein Gutschein, der einem Endverbraucher einen Anspruch auf ein prozentuales Cashback auf einen Einkauf oder Auftrag und einem Empfehler einen Anspruch auf ein prozentuales RECO.CASH verschafft.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was bedeutet RECO.CASH?',
            'answer' => 'RECO.CASH ist eine erfolgsabhängige Vergütung für eine erfolgreiche Empfehlung und unter anderem auch als Provision bekannt.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was genau ist Cashback?',
            'answer' =>
                <<<HTML
                    Cashback kommt aus dem Englischen und bedeutet &laquo;Geld zurück&raquo;. Dahinter steckt ein besonderes System, dass Deinen Kunden dabei hilft, Geld bei ihren Aufträgen und Einkäufen zu sparen. Auf den Punkt gebracht bedeutet es, dass Dein Kunde einen Teil seines Einkaufswertes nach dem Einkauf zurückerhält.

Ein kleines Beispiel:

Dein Kunde kauft bei Dir ein Produkt für 1190 Euro. Der Nettobetrag ist 1000 und die Cashback Rate liegt bei 10 %. Somit erhält Dein Kunde 100 Euro Cashback. Das Cashback bekommt er ganz praktisch nach der kompletten Auftragsabwicklung gutgeschrieben, anschließend kann er es auf sein Bankkonto überweisen lassen. 
HTML
            ,
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Muss ich RECO.BONS annehmen?',
            'answer' => 'Ja, gültige RECO.BONS musst Du annehmen. Sollten die Bedingungen und Ausschlüsse für den Auftrag nicht passen oder die Gültigkeit des RECO.BONS abgelaufen sein, bist Du jedoch nicht zur Einlösung verpflichtet.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wie hoch ist die Provision, Cashback und die Gebühr von RECO.MA?',
            'answer' =>
                <<<HTML
                    Das hängt ganz von Dir ab. Das Cashback sowie die Provision legst Du selbst fest, während Du den RECO.BON erstellst. Wichtig ist, dass es prozentuale Werte und keine vollen Beträge sind.

Die Portalgebühr von RECO.MA beträgt 1 %.

Das Cashback, das RECO.CASH sowie die Portalgebühr werden vom Netto Rechnungsbetrag berechnen. 
HTML
            ,
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Muss ich das RECO.CASH und das Cashback selbst auszahlen?',
            'answer' => 'Nein. Wir haben automatisierte Zahlungsläufe. Sobald Du uns mit einem Klick auf &laquo;ZAHLUNG ERHALTEN&raquo; mitteilst, dass Dein Kunde den fälligen Rechnungsbetrag vollständig beglichen hat, beginnt unser Zahlungslauf. Wir ziehen den offenen Betrag zunächst von Deinem Konto ein und schreiben das RECO.CASH dem Empfehler sowie das Cashback dem Kunden gut. Sobald Dein Kunde und Empfehler die Auszahlung im eigenen Dashboard anfordern, überweisen wir die jeweiligen Beträge an die hinterlegten Bankverbindungen.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wann hat der Empfehler Anspruch auf das RECO.CASH?',
            'answer' => 'Der Anspruch des Empfehlers entsteht nicht für den Empfehlungsabschluss, sondern erst, nachdem der Auftrag oder Kauf ausgeführt und der Rechnungsbetrag bei Dir vollständig durch den empfohlenen Kunden beglichen wurde. Sollte der Auftrag oder Kauf nachträglich im Rahmen der gesetzlichen Regelungen sowie Deiner allgemeinen Geschäftsbedingungen storniert werden, erlischt der Anspruch des Empfehlers auf das RECO.CASH.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wann hat mein Kunde Anspruch auf das Cashback?',
            'answer' => 'Der Anspruch des Kunden entsteht nicht für den Auftrags- bzw. Kaufabschluss, sondern erst, nachdem der Auftrag oder Kauf ausgeführt und der Rechnungsbetrag durch Deinen Kunden vollständig beglichen wurde. Sollte der Auftrag oder Kauf nachträglich im Rahmen der gesetzlichen Regelungen sowie Deiner allgemeinen Geschäftsbedingungen storniert werden, erlischt der Anspruch des Kunden auf das Cashback.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Was passiert, wenn der Kunde nicht bezahlt?',
            'answer' => 'Sollte einer Deiner Kunden den Rechnungsbetrag nicht bezahlen, müssen weder das RECO.CASH, das Cashback noch die Portalgebühr bezahlt werden.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Wie lange ist die Laufzeit?',
            'answer' => 'Die Laufzeit beträgt 12 Monate. Die Mitgliedschaft verlängert sich bei Nicht-Kündigung automatisch um weitere 12 Monate.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Wie sind die Kündigungsfristen?',
            'answer' => 'Die Kündigungsfrist beträgt einen Monat zum Ende des Mitgliedsjahres.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Mitgliedschaft',
            'question' => 'Wie kann ich kündigen?',
            'answer' =>
                <<<HTML
    Du kannst schriftlich per Brief an

Kündigung c/o

RECO.MA GmbH

zur Hollergewann 3

35638 Leun-Biskirchen

oder per E-Mail an <a href="mailto:cancel@reco.ma">cancel@reco.ma</a> kündigen.
HTML
            ,
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Kommen noch weitere Kosten auf mich zu?',
            'answer' => 'Neben dem monatlichen bzw. jährlichen Mitgliedsbeitrag und den geschäftsfallabhängigen RECO.CASH, Cashback und der Portalgebühr kommen keine weiteren Kosten auf Dich zu.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Wann ist das RECO.CASH fällig?',
            'answer' => 'Sobald Dein Kunde den Rechnungsbetrag vollständig beglichen hat.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Wann ist das Cashback fällig?',
            'answer' => 'Sobald Dein Kunde den Rechnungsbetrag vollständig beglichen hat.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Zahlung',
            'question' => 'Wann zahle ich die Portalgebühr an RECO.MA?',
            'answer' => 'Sobald der Kunde seinen Rechnungsbetrag vollständig beglichen hat.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie erstelle ich einen neuen RECO.BON?',
            'answer' =>
                <<<HTML
                    Du kannst einen RECO.BON aus dem Dashboard erstellen, indem Du folgende Schritte befolgen:
<ul>
    <li>Klicke im Dashboard das Schaltfeld &laquo;RECO.BON ERSTELLEN&raquo;. Alternativ gelangst Du über den Menüpunkt &laquo;Meine RECO.BONS&raquo; in die Übersicht Deiner erstellten RECO.BONS, dort findest Du ebenfalls das Schaltfeld &laquo;RECO.BON ERSTELLEN&raquo;</li> 
    <li>Trage nun der Reihe nach</li>  
    <ul>
        <li>as Cashback für den Verbraucher in Prozent. Gib hier bitte nur die Zahl ohne das Prozentzeichen ein,</li> 

        <li>den Titel des RECO.BONS (die Länge des Titels ist der Übersicht halber beschränkt),</li>

        <li>das Ablaufdatum des RECO.BONS. Es ist das Datum, ab dem der RECO.BON nicht mehr aktiv auf RECO.MA angeboten wird,</li> 

        <li>Bedingungen und Ausschlüsse des RECO.BONS,</li> 

        <li>die Provision bzw. das RECO.CASH für den Empfehler in Prozent. Gib hier bitte nur die Zahl ohne das Prozentzeichen ein,</li> 

        <li>die Gültigkeit des empfohlenen RECO.BONS. Es ist der Zeitraum, indem der RECO.BON, ab der Empfehlung gültig ist.</li> 

        <li>die maximale Anzahl der RECO.BONS, die ausgegeben werden sollen, ein.</li>  
    </ul>
In der Vorschau wird dargestellt wie der Verbraucher Deinen RECO.BON tatsächlich sehen wird.

    <li>Klicke auf &laquo;Speichern&raquo;</li>  
</ul>
Dein RECO.BON ist sofort aktiv und Du gelangst anschließend in die Übersicht Deiner RECO.BONS im Menüpunkt &laquo;Meine RECO.BONS&raquo;. Der Status des RECO.BONS wird in der RECO.BON Übersicht als &laquo;aktiv&raquo; angezeigt. 
HTML
            ,
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Ein Kunde legt mir einen RECO.BON vor. Wie löse ich den RECO.BON ein?',
            'answer' =>
                <<<HTML
                    Du kannst einen RECO.BON aus dem Dashboard einlösen in dem Du folgende Schritte befolgst:
<ul>
    <li>Klicke im Dashboard das Schaltfeld &laquo;RECO.BON einlösen&raquo;. Alternativ gelangst Du über den Menüpunkt &laquo;Eingelöste RECO.BONS&raquo; in die Übersicht Deiner eingelösten RECO.BONS. Dort findest Du das Feld &laquo;RECO.BON einlösen&raquo;.</li>  
    <li>Tragen nun der Reihe nach</li>  
    <ul>
        <li>den RECO.CODE des vorgezeigten RECO.BONS</li>  
        <li>den Netto Rechnungsbetrag des erhaltenen Auftrages ein</li> 
    </ul>
    <li>Klicke jetzt auf &laquo;Einlösen&raquo;</li>
</ul>
Der RECO.BON wird sofort eingelöst und erscheint im Feld &laquo;Eingelöste RECO.BONS&raquo;
HTML
            ,
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie kann ich die Zahlung des Kunden bestätigen?',
            'answer' =>
                <<<HTML
                    Du kannst die Zahlung des Kunden bestätigen, indem Du folgende Schritte befolgst:
<ul>
    <li>Klicke auf den Menüpunkt &laquo;Eingelöste RECO.BONS&raquo;. Hier findest du die entsprechende Transaktion, solltest Du die Transaktionen nicht direkt finden, kannst Du im Suchfeld den Namen deines Kunden oder den RECO.CODE eingeben, anschließend wird Dir die Transaktion angezeigt.</li>  
    <li>Klicke auf den grünen Button &laquo;ZAHLUNG BESTÄTIGEN&raquo; um Deinen Zahlungserhalt zu bestätigen.</li> 
</ul>
Das Cashback, das RECO.CASH sowie die Portalgebühr werden anschließend per Lastschrift von Deinem Konto abgebucht und im Dashboard der jeweiligen Parteien gutgeschrieben. Nach einer Haltefrist von 10 Tagen kann das Cashback im Gegenzug zu einer Bewertung Deines Kunden sowie das RECO.CASH vom Empfehler auf sein Konto ausgezahlt werden. 
HTML
            ,
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie erhalte ich Bewertungen auf RECO.MA?',
            'answer' => 'Du erhältst von jedem Kunden, der einen RECO.BON bei Dir eingelöst hat und den Rechnungsbetrag bezahlt hat, eine Bewertung. Erst nachdem die Bewertung abgegeben wurde, kann Dein Kunde sein Cashback auszahlen lassen. Damit möchten wir erreichen, dass alle Geschäftsfälle fair bewertet werden und sich weitere Empfehler und Verbraucher objektiv an vorherigen Erfahrungen orientieren und sich für oder gegen ein Unternehmen entscheiden können.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie zahle ich RECO.CASH, Cashback und Portalgebühr?',
            'answer' => 'Die Zahlung erfolgt über eine Lastschrift von Deinem Bankkonto, zu der Du uns während Deiner Registrierung ermächtigt hast.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wann wird mein Konto mit RECO.CASH, Cashback und Portalgebühr belastet?',
            'answer' => 'Sobald Du die Zahlung des Kunden erhalten und dies im Portal vermerkt hast, beginnt der Zahlungslauf.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Können Rechnungen und Belege per Post versendet werden?',
            'answer' => 'Nein. Zum jetzigen Zeitpunkt stehen Dir Rechnungen und Belege als PDF Download zur Verfügung.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Wie erhalte ich meine Rechnung?',
            'answer' =>
                <<<HTML
                    Du kannst Deine Rechnungen und Belege als PDF-Dokument herunterladen, indem Du folgende Schritte befolgst:
<ul>
    <li>Klicke auf &laquo;Konto&raquo; im linken Menü</li> 
    <li>In der Spalte &laquo;Beleg&raquo; findest Du die Rechnung oder den Beleg zur jeweiligen Transaktion.</li> 
    <li>Klicken auf den Button &laquo;PDF&raquo;</li> 
</ul>
Das Dokument kannst Du nun auf Deinem Computer speichern oder ausdrucken.    
HTML
            ,
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Kann ich ungerechte Bewertungen löschen?',
            'answer' => 'Du kannst Dich bei ungerechten Bewertungen mit uns in Verbindung setzen. Wir werden den Sachverhalt anschließend überprüfen.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Kann ich Transaktionen löschen?',
            'answer' => 'Generierte Transaktionen sind unwiderruflich und können somit auch nicht mehr gelöscht werden. Die Transaktionen werden jedoch erst generiert, nachdem Du von Deinem Kunden die Zahlung erhalten hast und diese auch im System bestätigst.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur RECO.MA Nutzung',
            'question' => 'Kann ich Transaktionen stornieren?',
            'answer' => 'Generierte Transaktionen sind unwiderruflich und können somit auch nicht mehr storniert werden. Die Transaktionen werden jedoch erst generiert, nachdem Du von Deinem Kunden die Zahlung erhalten hast und diese auch im System bestätigst.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zum Profil',
            'question' => 'Wie ändere ich meine Profildaten?',
            'answer' => 'Du kannst Deine Stamm- bzw. Profildaten in Deinem geschützten Bereich unter dem Menüpunkt &laquo;Profil&raquo; ändern. Nach der Aktualisierung musst Du die Änderung mit &laquo;Speichern&raquo; bestätigen.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zum Profil',
            'question' => 'Wie ändere ich mein Passwort?',
            'answer' => 'Du kannst Dein Passwort in Deinem geschützten Bereich im Menüpunkt &laquo;Profil&raquo; im Reiter &laquo;Passwort&raquo; ändern. Nach der Aktualisierung musst Du die Änderung mit &laquo;Speichern&raquo; bestätigen.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Fragen zur Sicherheit',
            'question' => 'Wer hat außer mir noch Zugriff auf meine Verkaufs- und Erfolgskennzahlen?',
            'answer' => 'Du hast den alleinigen Zugriff auf Dein RECO.MA Dashboard. Bitte gib Deine Anmeldedaten nie an Dritte weiter. Deine Datensicherheit ist uns sehr wichtig.',
            'roles' => 'seller'
        ],
        [
            'group' => 'Allgemeine Fragen',
            'question' => 'Wie erreiche ich den Support von RECO.MA?',
            'answer' =>
                <<<HTML
    Solltest Du weitere Fragen haben, die hier nicht beantwortet wurden, wende Dich bitte per E-Mail an: <a href="mailto:support@reco.ma">support@reco.ma</a>.
Bitte teile uns Deine E-Mail-Adresse, Telefonnummer sowie das Anliegen mit, damit sich einer unserer Mitarbeiter umgehend bei Dir melden kann.

Telefonisch ist der RECO.MA Support rund um die Uhr unter 0800 2888 444 erreichbar.
HTML
            ,
            'roles' => 'agent,consumer,seller'
        ],
    ];

    /**
     * Method to get grouped FAQ questions by scope.
     *
     * @param array $scope
     * @return array
     */
    public static function getGrouped($scope = ['agent', 'consumer', 'seller'])
    {
        $sortedFaq = [];

        foreach (self::$groups as $group) {
            $sortedFaq[$group] = [];
        }

        $faq = self::$faq;

        $questions = [];

        foreach ($faq as $article) {
            if ( in_array(trim($article['question']), $questions) ) {
                continue;
            }

            $roles = explode(',', $article['roles']);
            if ($roles == null) {
                $roles = $article['roles'];
            }

            $inScope = false;
            foreach ($roles as $r) {
                if ( in_array($r, $scope) ) {
                    $inScope = true;
                    break;
                }
            }

            if (!$inScope) {
                continue;
            }

            $sortedFaq[trim($article['group'])][] = [
                'question' => $article['question'],
                'answer'   => $article['answer'],
            ];

            $questions[] = trim($article['question']);
        }

        return $sortedFaq;
    }
}
