<?php

namespace App\Events;

use App\User;
use Illuminate\Queue\SerializesModels;

class EmployeeEdited extends Event
{
    use SerializesModels;

    public $seller;

    public $employee;

    public $oldData;

    public $data;

    /**
     * Create a new event instance.
     *
     * @param User $seller
     * @param User $employee
     * @param $oldData
     * @param $data
     */
    public function __construct(User $seller, User $employee, $oldData, $data)
    {
        $this->seller   = $seller;
        $this->employee = $employee;
        $this->oldData  = $oldData;
        $this->data     = $data;
    }
}
