<?php

namespace App\Events;

use App\User;
use Illuminate\Queue\SerializesModels;

class EmployeeDeleted extends Event
{
    use SerializesModels;

    public $seller;

    public $employee;

    /**
     * Create a new event instance.
     *
     * @param User $seller
     * @param User $employee
     */
    public function __construct(User $seller, User $employee)
    {
        $this->seller   = $seller;
        $this->employee = $employee;
    }
}
