<?php

namespace App\Events;

use App\User;
use Illuminate\Queue\SerializesModels;

class EmployeeAdded extends Event
{
    use SerializesModels;

    public $seller;

    public $employee;

    public $data;

    /**
     * Create a new event instance.
     *
     * @param User $seller
     * @param User $employee
     * @param $data
     */
    public function __construct(User $seller, User $employee, $data)
    {
        $this->seller   = $seller;
        $this->employee = $employee;
        $this->data     = $data;
    }
}
