<?php

namespace App\Console\Commands;

use App\BankTransaction;
use App\Transaction;
use Illuminate\Console\Command;

class TransactionReleaseEligible extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'transaction:release-eligible
        {--override : Whether to override the grace period}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Release transactions after X days';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Transaction::releaseAllEligible($this->option('override'));
    }
}
