<?php

namespace App\Console\Commands;

use App\Services\SessionService;
use Illuminate\Console\Command;

class SessionCleanup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'session:cleanup {hours=24 : Should remove empty sessions older than X hours}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove empty sessions (where user_id = NULL)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $hours = (int)$this->argument('hours');

        $removedSessions = SessionService::removeOld($hours);

        if ($removedSessions) {
            $this->info($removedSessions . ' old session(s) successfully removed');
        } else {
            $this->info('There are no items to remove');
        }
    }
}
