<?php

namespace App\Console\Commands;

use App\Account;
use Carbon\Carbon;
use Illuminate\Console\Command;

class SellerCreateInvoices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seller:create-invoices';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create monthly/yearly invoices';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $accounts = Account::whereNotNull('received_seller_role_at')->get();

        foreach ($accounts as $account) {
            if (!$account->users()->first()->email_verified) {
                continue;
            }
            if ($account->billed_until == null || $account->billed_until->lte(\Carbon\Carbon::today())) {
                $account->createMembershipInvoice();
            }
        }
    }
}
