<?php

namespace App\Console\Commands;

use App\Services\DealService;
use Illuminate\Console\Command;

class RemoveDraftDeals extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'deals:remove-draft {minutes=180 : Should remove draft deals older than X minutes}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove draft deals';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @param DealService $dealService
     * @return mixed
     */
    public function handle(DealService $dealService)
    {
        $minutes = (int)$this->argument('minutes');

        $removed = $dealService->removeDraft($minutes);

        if ($removed) {
            $this->info($removed . ' item(s) successfully removed');
        } else {
            $this->info('There are no items to remove');
        }
    }
}
