<?php

namespace App\Console\Commands;

use App\Services\PayPalService;
use Illuminate\Console\Command;

class PayPalPayOut extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'paypal:payout';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Pay out all PayPal credit notes, requested to payout';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $payPalService = new PayPalService();

        $processedCount = $payPalService->processPayOuts();
        $finishedCount = $payPalService->finalizePayOuts();

        if ($processedCount) {
            $this->info($processedCount . ' credit note(s) sent to PayPal');
        }

        if ($finishedCount) {
            $this->info($finishedCount . ' credit note(s) finished');
        }

        if (!$processedCount && !$finishedCount) {
            $this->info('There are no items to process');
        }
    }
}
