<?php

namespace App\Console\Commands;

use App\Services\DealService;
use App\Services\MediaService;
use Illuminate\Console\Command;

class DraftRemove extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'draft:remove {minutes=180 : Should remove draft items older than X minutes}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove draft items (deals, media)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $minutes = (int)$this->argument('minutes');

        $removedDeals = DealService::removeDraft($minutes);
        $removedMedia = MediaService::removeDraft($minutes);

        if ($removedDeals) {
            $this->info($removedDeals . ' draft deals(s) successfully removed');
        }

        if ($removedMedia) {
            $this->info($removedMedia . ' draft media(s) successfully removed');
        }

        if (!$removedDeals && !$removedMedia) {
            $this->info('There are no items to remove');
        }
    }
}
