<?php

namespace App\Console\Commands;

use App\AbstractReceipt;
use App\BankTransaction;
use App\Invoice;
use Illuminate\Console\Command;

class BankTransactionRetoureFake extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bank-transaction-retoure:fake {invoiceNumber} {message}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fake a bank transaction for invoice and process it.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $message = $this->argument('message');
        $invoice = Invoice::findByNumber($this->argument('invoiceNumber'));
        BankTransaction::createFakeFromReceipt($invoice, true, $message);
    }
}
