<?php

namespace App\Console\Commands;

use App\AbstractReceipt;
use App\BankTransaction;
use Illuminate\Console\Command;

class BankTransactionFake extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bank-transaction:fake {receiptNumber}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fake a bank transaction for receipt and process it. GS... or RE...';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $number = $this->argument('receiptNumber');
        $receipt = AbstractReceipt::findByNumber($number);
        if ($receipt == null) {
            $this->error('Not found');
            return;
        }
        BankTransaction::createFakeFromReceipt($receipt);
    }
}
