<?php

namespace App;

use App\Presenters\ActivityPresenter;
use App\Presenters\PresentsData;
use Illuminate\Database\Eloquent\Model;

class Activity extends Model
{
    use PresentsData;

    protected $presenter = ActivityPresenter::class;

    protected $table = 'user_log';

    protected $guarded = [];

    protected $casts = [
        'changes' => 'object',
    ];

    /**
     * Relation with user.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('\App\User');
    }

    /**
     * Relation with action.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function action()
    {
        return $this->belongsTo('\App\Action');
    }

    /**
     * Relation with useragent.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function useragent()
    {
        return $this->belongsTo('\App\Useragent');
    }

    /**
     * Relation with user location.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function location()
    {
        return $this->belongsTo('\App\Location');
    }

    /**
     * Polymorphic relation with model item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function model()
    {
       return $this->morphTo();
    }
}