<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AccountConnection extends AbstractModel
{
    const STATUS_ACTIVE = 'active';
    const NEWSLETTER_REQUEST = 'newsletter-request';
    const AGENT = 'agent';
    const STATUS_REJECTED = 'rejected';

    protected $fillable = [
        'account_id',
        'related_account_id',
        'type',
        'status',
        'token'
    ];

    public function AgentNewsletter($sellerAccount, $agentAccount,$token)
    {
        $accountConnection = [
            'account_id' => $agentAccount->id,
            'related_account_id' => $sellerAccount->id,
            'type' => self::NEWSLETTER_REQUEST,
            'status' => self::STATUS_ACTIVE,
            'token' => $token
        ];

        $this->fill($accountConnection);
        $this->save();

        return $this;
    }

    public function getSellerAccount()
    {
        return Account::where('id', '=', $this->related_account_id)->first();
    }

    public function createAccountConnection($sellerId, $agentId)
    {
        $accountConnection = [
            'account_id' => $agentId,
            'related_account_id' => $sellerId,
            'type' => self::AGENT,
            'status' => self::STATUS_ACTIVE
        ];

        $this->fill($accountConnection);
        $this->save();
    }

    public function reject()
    {
        $this->status = self::STATUS_REJECTED;
        $this->save();
    }
}
