<?php
namespace App;

use App\Library\Billomat\BillomatClientHelper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\HtmlString;

abstract class AbstractReceipt extends AbstractModel {

    /**
     * Billomat uses uppercase wording
     */
    const STATUS_DRAFT = 'DRAFT';
    const STATUS_OPEN = 'OPEN';
    const STATUS_EXPORTED = 'EXPORTED';
    const STATUS_COMPLETE = 'COMPLETE';
    const STATUS_BOOKED_BACK = 'BOOKED BACK';
    const STATUS_COLORS = [
        self::STATUS_DRAFT => 'default',
        self::STATUS_OPEN=> 'info',
        self::STATUS_EXPORTED => 'primary',
        self::STATUS_COMPLETE => 'success',
        self::STATUS_BOOKED_BACK => 'booked-back',
    ];

    /**
     * @deprecated Ein receipt kann mehrere transaktionen haben, verknüpfung über transactions()
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function transaction(){
        return $this->belongsTo(Transaction::class);
    }

    public function user() {
        return $this->belongsTo(User::class);
    }

    /**
     * Generate Purpose for Bank Statements
     *
     * @return string
     */
    public function getPurpose()
    {
        return 'RECO.MA Beleg ' . $this->number;
    }

    public static function generateMsgId($type)
    {
        $bic = config('banking.bic');
        return $bic . '-' . $type . '-' . date('Y-m-d-H-i-s');
    }

    /**
     * Create storage directory and get file name for SEPA writing
     *
     * @param $msgId
     * @return string
     */
    public static function createSepaFileName($msgId)
    {
        $path = storage_path('app/sepa');
        if (!file_exists($path)) {
            mkdir($path, 0770, true);
        }
        return $path . '/' . $msgId.  '.xml';
    }

    /**
     * Find a receipt (invoice or
     *
     * @param $number
     * @return mixed
     */
    public static function findByNumber($number) {
        if ($invoice = Invoice::whereNumber($number)->first()) {
            return $invoice;
        } else {
            return CreditNote::whereNumber($number)->first();
        }
    }

    public function markPaidAtBillomat($date) {
    	// FIXME: might make the class abstract
    }

    /**
     * Get signed amount (from the view of the operator's main account, i.e. invoices are positive, credit notes are negative)
     *
     * @return float
     */
    public abstract function getSignedAmount();

}