<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\HtmlString;

/**
 * Base Model for RECO.MA
 *
 */
abstract class AbstractModel extends Model
{
    use HasStatus;

    use HasCounters;

    /**
     * Define color coding (bootstrap label-* classes) for the different status
     */
    const STATUS_COLORS = [];

    /**
     * Specify attributes with are included in toArray(true)
     * @var array
     */
    protected $virtual_attributes = [];

    public function toArray($withVirtual = false)
    {
        $array = parent::toArray();
        if (!$withVirtual) {
            return $array;
        }
        foreach($this->virtual_attributes as $key) {
            $functionName = 'get' . ucfirst($key);
            $array[$key] = $this->$functionName();
        }
        return $array;
    }
}
