<?php

define( 'IROBO_MIN_VERSION', '1.6.0' ); // define minium irobo version here

if ( \Robo\Robo::APPLICATION_NAME != 'iRobo'
     || \Composer\Semver\Comparator::lessThan( \Robo\Robo::VERSION, IROBO_MIN_VERSION ) ) {
	echo 'ERROR: This script needs iRobo (not only robo) version ' . IROBO_MIN_VERSION
	     . ' or later - download at http://irobo.imi.de/irobo.phar ' . PHP_EOL;
	die( 1 );
}

class RoboFile extends \Robo\Tasks {
	use \iMi\RoboPack\LoadTasks;

    public function __construct() {
        $this->stopOnFail();
    }


    /**
	 * Initial project setup
	 */
	public function setup() {
		$config = $this->askSetup();
		$this->_writeEnvFile( $config );
		$this->_artisan( 'key:generate' );
	}

	/**
	 * Update the project from VCS and everything else
	 */
	public function update() {
		$this->taskGitStack()
		     ->pull()->run();
		$this->updateDependencies();
		$this->_artisan( 'migrate' );
		$this->cacheFlush();
	}

	/**
	 * Update dependencies only
	 */
	public function updateDependencies() {
		$this->taskComposerInstall()->run();
	}

	/**
	 * Replace the database with a clean one
	 */
	public function dbReplace() {
		$this->_artisan( 'migrate:refresh --seed' );
	}

	/**
	 * Flush all caches we know about
	 */
	public function cacheFlush() {
		$this->_artisanCacheFlush();
	}

	/**
	 * Update ide helpers - needs https://github.com/barryvdh/laravel-ide-helper
	 */
	public function updateIdeHelper() {
		$this->taskArtisanStack()->addUpdateIdeHelper()->run();
	}

	/**
	 * Deploy on preview
	 */
	public function deployTesting()
	{
		$this->taskSshExec('reco.ma.testing.imi.de', 'www-data')
		     ->remoteDir('/var/www/html/reco.ma.testing.imi.de/web')
		     ->exec('irobo update')
		     ->run();
	}

	/**
	 * Deploy on testing
	 */
	public function deployPreview()
	{
		$this->taskSshExec('reco.ma.testing.imi.de', 'www-data')
		     ->remoteDir('/var/www/html/reco.ma.preview.imi.de/web')
		     ->exec('irobo update')
		     ->run();
	}

	/**
	 * Import geo data to the database
	 */
	public function setupGeodata()
	{
		$source = 'http://www.fa-technik.adfc.de/code/opengeodb/';
		$target = __DIR__ . '/storage/app/opengeodb/sql/';
		$stack = $this->taskFileSystemStack()
		              ->mkdir($target);

		foreach(['DE.sql', 'changes.sql', 'opengeodb-begin.sql', 'opengeodb-end.sql'] as $file) {
			if (file_exists($target . $file)) {
				$this->say($target . $file . ' already exists - skipping download');
				continue;
			}
			$stack->copy($source . $file, $target . $file);
		}
		$stack->run();

		$this->_exec('php artisan db:seed --class=OpengeodbSeeder');

	}

	/**
	 * Set all user's passwords to "dev"
	 */
	public function resetPasswords()
	{
		$this->_exec("echo \"DB::table('users')->update(array('password' => Hash::make('dev')));\" | php artisan tinker");
	}
}
